%% ELEN E4810 HW 4 - Lossy image compression
%   NOTE: Except for the TO-DO section, there is no need to edit the other 
%   sections of the code.
clear; clc;
figure(101); clf;
load('DCTQ.mat');

%% Read patches from image - see 'help image2patches':
[pats_in, patwh, im_array] = image2patches('fruits.png');
imsz = size(im_array);  npx = prod(imsz);

%% Process each patch:
avgenergy = zeros(8);               % keep track of the average DCT energy
nzeros = zeros(8);                  % count the number of nzeros

npatsin = numel(pats_in);
pats_rec = cell(npatsin,1);
for i = 1:npatsin
        %% TO-DO: Process each patch in this loop!
end
    
%% Reconstruct image from patches and show results:
im_rec = cell2mat(reshape(pats_rec, patwh));
im_diff = im_array-im_rec;
fprintf(['Original size: %dx%d = %d px.\nNonzeros after quantization: %d.' ...
    '\nCompression ratio: %.2e. \nRMSE: %.2e.    Mean abs. dev.: %.2e\n\n'], ...
    imsz(1), imsz(2), npx, sum(nzeros(:)), npx/sum(nzeros(:)), ...
    norm(im_diff(:))/sqrt(npx), norm(im_diff,1)/npx);

figure(101);
subplot(221); imagesc(im_array, [0 255]); colormap('gray');
title('Original image');
subplot(222); imagesc(im_rec, [0 255]); colormap('gray');
title('Reconstructed image');
subplot(223); imagesc(log(avgenergy)); colormap('gray');
title('log average DCT energies on patches'); colorbar;
subplot(224); imagesc(log(nzeros/npatsin)); colormap('gray');
title('log frequency of nzeros on DCT after quantization'); colorbar;